SELECT L_RETURNFLAG, L_LINESTATUS, SUM(L_QUANTITY) AS SUM_QTY,
SUM(L_EXTENDEDPRICE) AS SUM_BASE_PRICE,
SUM(dbo.discount_price(L_EXTENDEDPRICE, L_DISCOUNT)) AS SUM_DISC_PRICE,
SUM(dbo.discount_taxprice(L_EXTENDEDPRICE, L_DISCOUNT, L_TAX)) AS SUM_CHARGE,
AVG(L_QUANTITY) AS AVG_QTY,
AVG(L_EXTENDEDPRICE) AS AVG_PRICE, AVG(L_DISCOUNT) AS AVG_DISC,
COUNT(*) AS COUNT_ORDER
FROM LINEITEM
WHERE dbo.isShippedBefore(L_SHIPDATE, -90, '1998-12-01') = 1
GROUP BY L_RETURNFLAG, L_LINESTATUS
ORDER BY L_RETURNFLAG, L_LINESTATUS;